/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx__endpoint.c,v 1.49 2006/09/13 02:23:15 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__request.h"
#  include "mx__partner.h"
#include "mx__endpoint.h"
#include "mx__handle_map.h"
#include "mx__wait_queue.h"
#include "mx__wire.h"
#include "mx__debug_dump.h"

struct mx_endpoint *Mx_endpoints = NULL;

void mx__conservation_of_matter(struct mx_endpoint *ep)
{
  int count = 0;
  int free_count = 0;
  int waiters;
  uint32_t i;
  union mx_request *r;
  struct mx__request_queue_head *elt;
  int mcp_handle_count = 0;
  int liback_queued = 0;
  struct mx__request_lookaside *rl;

  rl = &ep->req_lookaside;

  if (mx__opt.matter_debug >= 2) {
    struct mx__request_queue_head * elt;
    for(elt = rl->request_buffers_queue.next; elt != NULL; elt = elt->next) {
      union mx_request * reqs = (union mx_request *) ((char*)elt) + sizeof(elt);
      for (i=0; i<REQ_CHUNK; i++) {
	if ((reqs[i].basic.state & MX__REQUEST_STATE_DBGFLAG)) {
	  mx_printf("reqs[%d].basic.state == 0x%x\n", i, reqs[i].basic.state);
	  mx_fatal("DBGFLAG present at begin of mx__conservation_of_matter");
	}
	reqs[i].basic.state |= MX__REQUEST_STATE_DBGFLAG;
      }
    }
    
    for (elt = rl->free_requests_queue.next, i=0; elt != NULL; elt = elt->next, i++) {
      r = MX__REQUEST_FROM_QUEUE_ELT(elt);
      r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
      mx_assert(r->basic.state & MX__REQUEST_STATE_FREED);
      free_count += 1;
    }

    mx_assert(rl->count == free_count);
  }

  count += mx__count_requests(&ep->send_reqq);
  count += mx__count_requests(&ep->resend_reqq);
  MX__FOREACH_REQ(r, elt, &ep->send_reqq) {
    r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
    mx_assert(r->basic.state & MX__REQUEST_STATE_SEND_QUEUED);
    mx_assert(!(r->basic.state & MX__REQUEST_STATE_MCP));
    switch (r->basic.type) {
    case MX__REQUEST_TYPE_SEND_TINY:
    case MX__REQUEST_TYPE_SEND_SMALL:
    case MX__REQUEST_TYPE_SEND_MEDIUM:
      mx_assert(!r->basic.requeued || r->basic.state & MX__REQUEST_STATE_BUFFERED);
      break;
    case MX__REQUEST_TYPE_LIBACK:
      liback_queued += 1;
      break;
    default:
      break;
    }
  }
  MX__FOREACH_REQ(r, elt, &ep->resend_reqq) {
    r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
    mx_assert(r->basic.state & MX__REQUEST_STATE_SEND_QUEUED);
    mx_assert(!(r->basic.state & MX__REQUEST_STATE_MCP));
    switch (r->basic.type) {
    case MX__REQUEST_TYPE_SEND_TINY:
    case MX__REQUEST_TYPE_SEND_SMALL:
    case MX__REQUEST_TYPE_SEND_MEDIUM:
      mx_assert(!r->basic.requeued || r->basic.state & MX__REQUEST_STATE_BUFFERED);
      break;
    case MX__REQUEST_TYPE_LIBACK:
      liback_queued += 1;
      break;
    default:
      break;
    }
  }
  for(i = 0; i < ep->ctxid_max; i++) {  
    count += mx__count_requests(&ep->ctxid[i].recv_reqq);
    MX__FOREACH_REQ(r, elt, &ep->ctxid[i].recv_reqq) {
      r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
      mx_assert((r->basic.state & ~MX__REQUEST_STATE_DEAD) == MX__REQUEST_STATE_PENDING);
    }
    count += mx__count_requests(&ep->ctxid[i].doneq);
    MX__FOREACH_REQ(r, elt, &ep->ctxid[i].doneq) {
      r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
      mx_assert(r->basic.state & MX__REQUEST_STATE_COMPLETED);
    }
    count += mx__count_requests(&ep->ctxid[i].unexpq);
    MX__FOREACH_REQ(r, elt, &ep->ctxid[i].unexpq) {
      r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
      mx_assert(r->basic.state == MX__REQUEST_STATE_PENDING
		|| (r->basic.state & MX__REQUEST_STATE_COMPLETED));
      mx_assert(r->basic.type == MX__REQUEST_TYPE_RECV
		|| r->basic.type == MX__REQUEST_TYPE_RECV_LARGE
		|| r->basic.type == MX__REQUEST_TYPE_RECV_SELF
		|| r->basic.type == MX__REQUEST_TYPE_RECV_SHM);
    }
  }
  count += mx__count_requests(&ep->buffered_sendq);
  mcp_handle_count += mx__count_requests(&ep->buffered_sendq);
  MX__FOREACH_REQ(r, elt, &ep->buffered_sendq) {
    r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
    mx_assert(r->basic.state & MX__REQUEST_STATE_BUFFERED);
    mx_assert(r->basic.state & MX__REQUEST_STATE_MCP);
  }
  count += mx__count_requests(&ep->large_sendq);
  MX__FOREACH_REQ(r, elt, &ep->large_sendq) {
    r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
    mx_assert(r->basic.state & MX__REQUEST_STATE_MCP);
    mcp_handle_count +=  1;
  }
  count += mx__count_requests(&ep->notifying_large_sendq);
  MX__FOREACH_REQ(r, elt, &ep->notifying_large_sendq) {
    r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
    mx_assert(!(r->basic.state & (MX__REQUEST_STATE_REPLIED |
				  MX__REQUEST_STATE_MCP)));
  }
  count += mx__count_requests(&ep->large_getq);
  MX__FOREACH_REQ(r, elt, &ep->large_getq) {
    r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
#if !MX_NO_RNDV
    mx_assert(r->basic.state & MX__REQUEST_STATE_MCP);
#endif
    mcp_handle_count += !!(r->basic.state & MX__REQUEST_STATE_MCP);
    mx_assert(r->basic.state & MX__REQUEST_STATE_RECV_MATCHED);
  }
  count += mx__count_requests(&ep->multifrag_recvq);
  MX__FOREACH_REQ(r, elt, &ep->multifrag_recvq) {
    r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
    mx_assert(r->basic.state == (MX__REQUEST_STATE_PENDING|MX__REQUEST_STATE_RECV_MATCHED));
  }
  /* connect requests are either in the connectq (when waiting for the reply),
   * in the doneq (for replied iconnect) or in connect_count */
  count += mx__count_requests(&ep->mcp_connectq);
  count += ep->connect_count;
  MX__FOREACH_REQ(r, elt, &ep->mcp_connectq) {
    r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
    mx_assert(!(r->basic.state & ~(MX__REQUEST_STATE_MCP |
				   MX__REQUEST_STATE_ACKED |
				   MX__REQUEST_STATE_DEAD |
				   MX__REQUEST_STATE_COMPLETED)));
    mx_assert(r->basic.state & MX__REQUEST_STATE_MCP);
    mcp_handle_count += 1;
  }
  count += mx__count_requests(&ep->mcp_connect_replyq);
  mcp_handle_count += mx__count_requests(&ep->mcp_connect_replyq);
  MX__FOREACH_REQ(r, elt, &ep->mcp_connect_replyq) {
    r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
    mx_assert(r->basic.state == MX__REQUEST_STATE_MCP);
  }
  count += mx__count_requests(&ep->resend_list);
  MX__FOREACH_REQ(r, elt, &ep->resend_list) {
    r->basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
    mx_assert(!(r->basic.state & (MX__REQUEST_STATE_MCP |
				  MX__REQUEST_STATE_SEND_QUEUED)));
  }

  mx_always_assert(mx__wait_queue_length(&ep->wait_queue_head) == ep->wait_waiters);

  for (i = 0, waiters = 0; i < ep->ctxid_max; i++)
    waiters += mx__wait_queue_length(&ep->ctxid[i].probe_queue_head);
  mx_always_assert(waiters == ep->probe_waiters);

  for (i = 0, waiters = 0; i < ep->ctxid_max; i++)
    waiters += mx__wait_queue_length(&ep->ctxid[i].peek_queue_head);
  mx_always_assert(waiters == ep->peek_waiters);

  count += ep->sendself_count;

  count += ep->sendshm_count;

  count += ep->acquired_by_wait_any_count;

  if (ep->wake_pending)
    mcp_handle_count += 1;

  count += ep->liback_count - liback_queued;

  mcp_handle_count += ep->liback_count - liback_queued;

  mx_always_assert(mcp_handle_count ==
		   ep->handle_map->total_count - ep->handle_map->free_count);
  if (count != ep->req_lookaside.alloc_count - ep->req_lookaside.count) {
    mx_printf("Radioactivity: counted=%d, should be %d=%d(alloc) - %d(free)\n",
	      count, rl->alloc_count - rl->count,
	      rl->alloc_count, rl->count);
    mx_printf("sendself=%d\n", ep->sendself_count);
    mx_printf("sendshm=%d\n", ep->sendshm_count);
    mx_printf("liback_count =%d, liback_queued = %d\n", ep->liback_count, liback_queued);

    if (mx__opt.matter_debug >= 2) {
      struct mx__request_queue_head * elt;
      for(elt = rl->request_buffers_queue.next; elt != NULL; elt = elt->next) {
	union mx_request * reqs = (union mx_request *) ((char*)elt) + sizeof(elt);
	for (i=0; i<REQ_CHUNK; i++) {
	  if (reqs[i].basic.state & MX__REQUEST_STATE_DBGFLAG)
	    mx__dump_request(ep, r+i);
	}
      }
    }
    mx_fatal("Conservation of matter failed");
  }
  if (mx__opt.matter_debug >= 2) {
    struct mx__request_queue_head * elt;
    for(elt = rl->request_buffers_queue.next; elt != NULL; elt = elt->next) {
      union mx_request * reqs = (union mx_request *) ((char*)elt) + sizeof(elt);
      for (i=0; i<REQ_CHUNK; i++)
	reqs[i].basic.state &= ~MX__REQUEST_STATE_DBGFLAG;
    }
  }
#if 0
  static int full_check;
  if (full_check++ % 256 != 0)
    return;
  for (i=0;i< 32 * ep->max_endpoints;i++) {
    struct mx__partner *p = ep->remote_ep[i];
    if (p && p->send_acked != MX__SEQNO(p->send_seq)) {
      union mx_request *r;
      struct mx__request_queue_head * elt;
      MX__FOREACH_REQ(r, elt, &ep->resend_list) {
	if (r->basic.partner == p &&
	    MX__SEQNO(r->basic.send_seq) == p->send_acked)
	  goto found;
      }
      MX__FOREACH_REQ(r, elt, &ep->buffered_sendq) {
	if (r->basic.partner == p &&
	    MX__SEQNO(r->basic.send_seq) == p->send_acked)
	  goto found;
      }
      mx_fatal("partner->send_acked request not found!!");
  found:
    ;
    }
  }
#endif
}

void mx__endpoint_init_eventq(struct mx_endpoint *ep)
{
  ep->eventq_uevt = (mcp_uevt_t *)ep->eventq;
  ep->eventq_index = 0;
  ep->eventq_flow = 0;
  ep->event_count = 0;
}

void mx__endpoint_init_recvq(struct mx_endpoint *ep)
{
  ep->recvq_loc = 0;
}

void
mx__dump_endpoint_stats(struct mx_endpoint *ep)
{
#if MX__EP_STATS
  mx_printf("Dumping MX statistics for endpoint %d on board %d:\n",
	    ep->myself->eid, ep->board_num);

  /* sends */
  mx_printf("isend tiny   (     0-% 6d): % 9d\n",
	    ep->tiny_msg_threshold, ep->stats.isend_tiny);
  mx_printf("isend small  (% 6d-% 6d): % 9d\n",
	    ep->tiny_msg_threshold+1, ep->small_msg_threshold, ep->stats.isend_small);
  mx_printf("isend medium (% 6d-% 6d): % 9d\n",
	    ep->small_msg_threshold+1, ep->medium_msg_threshold, ep->stats.isend_medium);
  mx_printf("isend large  (      >% 6d): % 9d\n",
	    ep->medium_msg_threshold, ep->stats.isend_large);
  mx_printf("isend total                 : % 9d\n",
	    ep->stats.isend_tiny+ep->stats.isend_small+ep->stats.isend_medium+ep->stats.isend_large);

  /* ssends */
  mx_printf("issend total                : % 9d\n", ep->stats.issend);

  /* recvs */
  mx_printf("irecv           : %d\n", ep->stats.irecv);
  mx_printf("expected        : %d\n", ep->stats.expected);
  mx_printf("unexpected      : %d (including %d claimed by the handler)\n", ep->stats.unexpected, ep->stats.unexpected_handled);
  mx_printf("early fragments : %d\n", ep->stats.early);

  /* overlap */
  mx_printf("overlap: %d test before completion out of %d\n", ep->stats.noncompleted_test, ep->stats.test);
  mx_printf("overlap: %d non-blocking wait out of %d\n", ep->stats.nonblocking_wait, ep->stats.wait);
  mx_printf("overlap: %d completion overlapped out of %d\n", ep->stats.overlapped_completion, ep->stats.completion);

  /* ack in the lib */
  mx_printf("resent_slow/resent: %d/%d\n", ep->stats.resent_slow, ep->stats.resent);
  mx_printf("delayed_acks/total_acks: %d/%d\n", ep->stats.delayed_acks, ep->stats.total_acks);

  /* rcache */
  mx_printf("rcache: hits %d (%lld kbytes) miss %d (%lld kbytes)\n",
	    ep->stats.rcache_hit, ep->stats.rcache_hit_kbytes,
	    ep->stats.rcache_miss, ep->stats.rcache_miss_kbytes);

  /* mcp handles */
  mx_printf("mcp handles: got %d missed %d\n", ep->stats.got_mcp_handle, ep->stats.no_mcp_handle);

#endif /* MX__EP_STATS */
}
